#include "stm32f10x.h"
#include "stm3210e_eval_fsmc_sram.h"

#define StartAddresse 	(uint32_t ) 0x68000000

/* Description :																			*/
/* Initilize the MCU Clock, the GPIO Pins corresponding to the 		*/
/* device and initilize the FSMC with the chosen configuration 		*/
/* Inputs 	:																				*/
/* 				 None 																		*/
/* outputs 	:																				*/
/* 				"1" 			: Operation succeeded								*/
/* 				"0" 			: Operation failure										*/
/* Note: Mandatory for all types of device 									*/

int Init (void)
{  
	/* Set MCU Clock */
	SystemInit();
	
	/* Enable the FSMC Clock */
        RCC_AHBPeriphClockCmd(RCC_AHBPeriph_FSMC, ENABLE);
	
	/* Init the External SRAM */
	SRAM_Init();
	
	return 1;
}

/* Description :																			*/
/* Read data from the device 													    */
/* Inputs :																					*/
/* 				Address 	: Read location  										*/
/* 				Size 		: Length in bytes 										*/
/* 				buffer 		: Address where to write readed data			*/
/* outputs :																				*/
/* 				"1" 			: Operation succeeded								*/
/* 				"0" 			: Operation failure										*/
/* Info :																						*/
/* Align and memory size (32/16/8 bits) is handled in this function 	*/
/* Note : Not Mandatory for SRAM PSRAM and NOR_FLASH 		*/			

int Read (uint32_t Address, uint32_t Size, uint32_t Buffer)
{ 
	uint32_t HalfWordSize = Size/2;
	
	if (Size%2 != 0)
		HalfWordSize++;
	
	SRAM_ReadBuffer((uint16_t*) Buffer, Address - StartAddresse, HalfWordSize);
	
	return 1;
} 


/* Description :																			*/
/* Write data to the device	 														*/
/* Inputs :																					*/
/* 				Address 	: Write location  										*/
/* 				Size 		: Length in bytes 										*/
/* 				buffer 		: Address where to get the data to write		*/
/* outputs :																				*/
/* 				"1" 			: Operation succeeded								*/
/* 				"0" 			: Operation failure										*/
/* Info :																						*/
/* Align and memory size (32/16/8 bits) is handled in this function 	*/
/* Note : Mandatory for all types except SRAM and PSRAM			*/	

int Write (uint32_t Address, uint32_t Size, uint32_t Buffer)
{
	uint32_t HalfWordSize = Size/2;
	
	if (Size%2 != 0)
		HalfWordSize++;
	
	SRAM_WriteBuffer((uint16_t*) Buffer, Address - StartAddresse , HalfWordSize);
	
	return 1;
} 

/* Description :																			*/
/* Full erase of the device 															*/
/* Inputs :																					*/
/* 				None 																		*/
/* outputs :																				*/
/* 				"1" : Operation succeeded											*/
/* 				"0" : Operation failure													*/
/* Info :																						*/
/* Note : Not Mandatory for SRAM PSRAM and NOR_FLASH		*/	

// int MassErase (void)
// {  
// 	return 1;
// }


/* Description :																			*/
/* Erase a full sector in the device 												*/
/* Inputs :																					*/
/* 				SectrorAddress	: Start of sector 								*/
/* outputs :																				*/
/* 				"1" : Operation succeeded											*/
/* 				"0" : Operation failure													*/
/* Note : Not Mandatory for SRAM PSRAM and NOR_FLASH		*/	

// int SectorErase (uint32_t SectrorAddress)
// {  
// 	return 1;
// }

