#!/bin/sh

# usage :
# 	wanesy UP   : set_wanesy.sh <proxy ip> <proxy port> [apn]
# 	wanesy DOWN : set_wanesy.sh down

. /etc/sysconfig/network

FIREWALL_CONFIG_FILE=/etc/firewall/iptables_wanesy.rules

# check first arg
if [ "$1" = "down" ]; then
	# KTERM --> KNONE
	sed -r -i -e "s;(<LOCAL_DEV role=).*$;<LOCAL_DEV role=\"KNONE\"/>;" /knet/knetd.xml
	# AUTOCONNECT --> NO
	sed -r -i -e "s;(<CONNECT auto_connection=).*$;<CONNECT auto_connection=\"NO\" />;" /knet/knetd.xml
	# Firewall rules
	rm -f $FIREWALL_CONFIG_FILE

	if [ "${FIREWALL}" = "yes" ]; then
		/etc/rc.d/init.d/firewall restart
	fi
	/etc/rc.d/init.d/knet restart

	exit 0
fi

# check number of args
if [ "$#" -lt 2 ]; then
	echo " $0 : error, too few arguments."
	exit 1
fi

# check validity of IP addr
valid_ip.sh $1
if [ "$?" -ne 0 ]; then
	echo " $0 : error, bad ip address."
	exit 1
fi

# check validity of port
TEST=`echo $2 | grep -E "([0-9]{1,5})"`
if [ ! "$TEST" ]; then
	echo " $0 : error, bad port."
	exit 1
fi


# KNONE --> KTERM
sed -r -i -e "s;(<LOCAL_DEV role=).*$;<LOCAL_DEV role=\"KTERM\"/>;" /knet/knetd.xml

# AUTOCONNECT --> YES
sed -r -i -e "s;(<CONNECT auto_connection=).*$;<CONNECT auto_connection=\"YES\" />;" /knet/knetd.xml

# SERVER IP
sed -r -i -e "s;(<SERVER address=).*$;<SERVER address=\"$1\"/>;" /knet/system.xml

# PORT NUMBER
sed -r -i -e "s;(<SERVER knet_port=).*$;<SERVER knet_port=\"$2\"/>;" /knet/system.xml

# set APN
if [ "$#" -eq 3 ]; then
	sed -r -i -e "s;(GPRSAPN=).*$;\1$3;" /etc/sysconfig/network
	sed -i -e '/bearer/ s/ethernet/gprs/' /knet/knetd.xml
	sed -r -i -e "s;(BEARERS_PRIORITY=).*$;\1\"ppp0,eth0\";" /etc/sysconfig/network
else
	sed -i -e '/bearer/ s/gprs/ethernet/' /knet/knetd.xml
	sed -r -i -e "s;(BEARERS_PRIORITY=).*$;\1\"eth0,ppp0\";" /etc/sysconfig/network
fi

# create firewall config file
mkdir -p /etc/firewall
cat > $FIREWALL_CONFIG_FILE << EOF
*filter
-A INPUT -p tcp -s $1 --sport $2 -j ACCEPT
COMMIT
EOF

if [ "${FIREWALL}" = "yes" ]; then
	/etc/rc.d/init.d/firewall restart
fi
/etc/rc.d/init.d/knet restart

exit 0
