#!/bin/sh

if [ "$1" == "" ]; then
	exit 1
fi

# Check block device is mounted
mount | grep -q $1
[ $? -ne 0 ] && exit 1

KEYFILE="usbkey.txt"
BOARDID=`fw_printenv ethaddr | awk 'BEGIN { FS = ":" } ; {print $3$4$5$6}'`

if [ -f "/etc/${KEYFILE}" ]
then
	if ! [ -f "/mnt/$1/${KEYFILE}" ]
	then
		logger -t usb "Secure key file not found on USB stick, abort update"
		exit 2
	else
		dos2unix -u "/etc/${KEYFILE}" "/mnt/$1/${KEYFILE}"
		# Try to find key in USB keyfile
		PRODUSBKEY="$(head -n 1 /etc/${KEYFILE})"
		grep -q "${PRODUSBKEY}$" "/mnt/$1/${KEYFILE}"
		if [ $? -ne 0 ]
		then
			logger -t dusb "Produsb key mismatch, abort update"
			exit 3
		fi
	fi
fi

# check presence of update flag
if [ -f /mnt/$1/produsb.sh ]; then
	grep $BOARDID /mnt/$1/produsb.log
	if [ $? -eq 0 ]; then
		logger -t usb "This board has already been flashed in produsb mode."
		exit 1
	fi

	# set update flag
	fw_setenv produsb 1
	logger -t usb "Go to PRODUSB mode."
	/sbin/reboot
elif [ -f /mnt/$1/update ]; then
	# set update flag
	fw_setenv update 1
	rm /mnt/$1/update
	logger -t usb "Go to UPDATE mode."
	/sbin/reboot
elif [ -x /mnt/$1/autorun_klk.sh ]; then
	logger -t usb "Executing /mnt/$1/autorun_klk.sh ..."
	/mnt/$1/autorun_klk.sh /mnt/$1
else
	echo "No magic file."
	exit 1
fi

exit 0
