#!/bin/sh

ntpd_restart()
{
  echo "restarting NTPD"
  if [ -e /var/run/ntpd.pid ]
  then
    killall ntpd
  fi
  /usr/sbin/ntpd -p /var/run/ntpd.pid -c /etc/ntp.conf
}

# 1 if we have to restart NTPD
needNtpdRestart=0
# pid of NTPD process
ntpdPid=`cat /var/run/ntpd.pid`
# name of gps0 pts file 
gps0RealFileName=`ls -l /dev/gps0 | awk '{print $11}'`
# boolean telling if gps file is openened by ntp process
gpsFileNotOpened=1

if [ "x${ntpdPid}" != "x" -a "x${gps0RealFileName}" != "x" ]
then
  ls -l /proc/${ntpdPid}/fd | grep ${gps0RealFileName} | grep -v deleted > /dev/null
  gpsFileNotOpened=$?
else
  gpsFileNotOpened=1
fi

if [ "x${needNtpdRestart}" = "x1" -o "x${gpsFileNotOpened}" != "x0" ]
then
  ntpd_restart
fi
